/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.printer;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.common.AbstractContainerBlockEntity;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.container.BasicContainer;
import dan200.computercraft.shared.container.BasicWorldlyContainer;
import dan200.computercraft.shared.media.items.PrintoutData;
import dan200.computercraft.shared.peripheral.printer.PrinterBlock;
import dan200.computercraft.shared.peripheral.printer.PrinterMenu;
import dan200.computercraft.shared.peripheral.printer.PrinterPeripheral;
import dan200.computercraft.shared.util.ColourUtils;
import dan200.computercraft.shared.util.DataComponentUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jspecify.annotations.Nullable;

public final class PrinterBlockEntity
extends AbstractContainerBlockEntity
implements BasicWorldlyContainer {
    private static final String NBT_PRINTING = "Printing";
    private static final String NBT_PAGE_TITLE = "PageTitle";
    static final int SLOTS = 13;
    private static final int[] BOTTOM_SLOTS = new int[]{7, 8, 9, 10, 11, 12};
    private static final int[] TOP_SLOTS = new int[]{1, 2, 3, 4, 5, 6};
    private static final int[] SIDE_SLOTS = new int[]{0};
    private final PrinterPeripheral peripheral = new PrinterPeripheral(this);
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)13, (Object)ItemStack.EMPTY);
    private final NetworkedTerminal page = new NetworkedTerminal(25, 21, true);
    private String pageTitle = "";
    private boolean printing = false;

    public PrinterBlockEntity(BlockEntityType<PrinterBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public IPeripheral peripheral() {
        return this.peripheral;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            this.printing = nbt.getBoolean(NBT_PRINTING);
            this.pageTitle = nbt.getString(NBT_PAGE_TITLE);
            this.page.readFromNBT(nbt);
        }
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            tag.putBoolean(NBT_PRINTING, this.printing);
            tag.putString(NBT_PAGE_TITLE, this.pageTitle);
            this.page.writeToNBT(tag);
        }
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registries);
        super.saveAdditional(tag, registries);
    }

    boolean isPrinting() {
        return this.printing;
    }

    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public void setItems(NonNullList<ItemStack> items) {
        BasicContainer.defaultSetItems(this.inventory, items);
    }

    public void setChanged() {
        super.setChanged();
        this.updateBlockState();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot == 0) {
            return PrinterBlockEntity.isInk(stack);
        }
        if (slot >= TOP_SLOTS[0] && slot <= TOP_SLOTS[TOP_SLOTS.length - 1]) {
            return PrinterBlockEntity.isPaper(stack);
        }
        return false;
    }

    public int[] getSlotsForFace(Direction side) {
        return switch (side) {
            case Direction.DOWN -> BOTTOM_SLOTS;
            case Direction.UP -> TOP_SLOTS;
            default -> SIDE_SLOTS;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable NetworkedTerminal getCurrentPage() {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            return this.printing ? this.page : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startNewPage() {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            if (!this.canInputPage()) {
                return false;
            }
            if (this.printing && !this.outputPage()) {
                return false;
            }
            return this.inputPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean endCurrentPage() {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            return this.printing && this.outputPage();
        }
    }

    int getInkLevel() {
        ItemStack inkStack = (ItemStack)this.inventory.get(0);
        return PrinterBlockEntity.isInk(inkStack) ? inkStack.getCount() : 0;
    }

    int getPaperLevel() {
        int count = 0;
        for (int i = 1; i < 7; ++i) {
            ItemStack paperStack = (ItemStack)this.inventory.get(i);
            if (!PrinterBlockEntity.isPaper(paperStack)) continue;
            count += paperStack.getCount();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPageTitle(String title) {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            if (this.printing) {
                this.pageTitle = title;
            }
        }
    }

    static boolean isInk(ItemStack stack) {
        return ColourUtils.getStackColour(stack) != null;
    }

    static boolean isPaper(ItemStack stack) {
        Item item = stack.getItem();
        return item == Items.PAPER || item == ModRegistry.Items.PRINTED_PAGE.get();
    }

    private boolean canInputPage() {
        return this.getInkLevel() > 0 && this.getPaperLevel() > 0;
    }

    private boolean inputPage() {
        ItemStack inkStack = (ItemStack)this.inventory.get(0);
        DyeColor dye = ColourUtils.getStackColour(inkStack);
        if (dye == null) {
            return false;
        }
        for (int i = 1; i < 7; ++i) {
            ItemStack paperStack = (ItemStack)this.inventory.get(i);
            if (paperStack.isEmpty() || !PrinterBlockEntity.isPaper(paperStack)) continue;
            this.page.setTextColour(dye.getId());
            this.page.clear();
            PrintoutData printout = (PrintoutData)paperStack.get((DataComponentType)ModRegistry.DataComponents.PRINTOUT.get());
            if (printout != null) {
                this.pageTitle = printout.title();
                for (int y = 0; y < this.page.getHeight(); ++y) {
                    PrintoutData.Line line = printout.lines().get(y);
                    this.page.setLine(y, line.text(), line.foreground(), "");
                }
            } else {
                this.pageTitle = "";
            }
            this.page.setCursorPos(0, 0);
            inkStack.shrink(1);
            if (inkStack.isEmpty()) {
                this.inventory.set(0, (Object)ItemStack.EMPTY);
            }
            paperStack.shrink(1);
            if (paperStack.isEmpty()) {
                this.inventory.set(i, (Object)ItemStack.EMPTY);
                this.updateBlockState();
            }
            this.setChanged();
            this.printing = true;
            return true;
        }
        return false;
    }

    private boolean outputPage() {
        int height = this.page.getHeight();
        PrintoutData.Line[] lines = new PrintoutData.Line[height];
        for (int i = 0; i < height; ++i) {
            lines[i] = new PrintoutData.Line(this.page.getLine(i).toString(), this.page.getTextColourLine(i).toString());
        }
        ItemStack stack = DataComponentUtil.createStack((ItemLike)ModRegistry.Items.PRINTED_PAGE.get(), (DataComponentType)ModRegistry.DataComponents.PRINTOUT.get(), new PrintoutData(this.pageTitle, List.of(lines)));
        for (int slot : BOTTOM_SLOTS) {
            if (!((ItemStack)this.inventory.get(slot)).isEmpty()) continue;
            this.inventory.set(slot, (Object)stack);
            this.updateBlockState();
            this.setChanged();
            this.printing = false;
            return true;
        }
        return false;
    }

    private void updateBlockState() {
        ItemStack stack;
        int i;
        boolean top = false;
        boolean bottom = false;
        for (i = 1; i < 7; ++i) {
            stack = (ItemStack)this.inventory.get(i);
            if (stack.isEmpty() || !PrinterBlockEntity.isPaper(stack)) continue;
            top = true;
            break;
        }
        for (i = 7; i < 13; ++i) {
            stack = (ItemStack)this.inventory.get(i);
            if (stack.isEmpty() || !PrinterBlockEntity.isPaper(stack)) continue;
            bottom = true;
            break;
        }
        this.updateBlockState(top, bottom);
    }

    private void updateBlockState(boolean top, boolean bottom) {
        if (this.remove || this.level == null) {
            return;
        }
        BlockState state = this.getBlockState();
        if ((Boolean)state.getValue((Property)PrinterBlock.TOP) == top && (Boolean)state.getValue((Property)PrinterBlock.BOTTOM) == bottom) {
            return;
        }
        this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)((BlockState)state.setValue((Property)PrinterBlock.TOP, (Comparable)Boolean.valueOf(top))).setValue((Property)PrinterBlock.BOTTOM, (Comparable)Boolean.valueOf(bottom)));
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new PrinterMenu(id, inventory, this);
    }
}

